#!/usr/bin/tclsh
# Filelist generator

source config

set numchars 0
proc OutLine {line} {
	global out numchars lmargin rmargin
	append line " "
	set len [string length $line]
	if [expr $numchars+$len > $rmargin] {
		# force newline
		puts -nonewline $out [format "\n%${lmargin}s" ""]
		set numchars $lmargin
	}
	incr numchars $len
	puts -nonewline $out $line
}

set areanum 0
proc ProcessDir {dir desc} {
	global out numchars areanum FNlength FSlength fileslist
	global makehtml htmlname
	
	set numfiles 0
	set numbytes 0
	incr areanum
	if [catch {set infile [open $dir/$fileslist]}] {
		puts stderr "$fileslist not exists in $dir"
		return
	}
	if {$makehtml} {
		set htmlout [open $dir/$htmlname w]
		puts $htmlout "<HTML><HEAD><TITLE>$desc</TITLE></HEAD><BODY><P><CENTER>$desc</CENTER><P><TABLE BORDER=1>"
	}
	puts $out         "͸"
	puts $out [format " #%3d  %-50s                   " $areanum $desc]
	puts $out         ";\n"
	while {[gets $infile line] >= 0} {
# check for empty and comment lines
		set firstchar [string index $line 0]
		if {$firstchar == " " || $firstchar == "\t" || $firstchar == ""} {
			puts $out $line
			set numchars 0
			if {$makehtml && $firstchar != ""} {
				puts $htmlout "<TR><TD></TD><TD><CENTER>$line</CENTER></TD></TR>"
			}
			continue
		}
		scan $line "%s" file
		if [catch {file stat $dir/$file filestat}] {
			# file not found
			OutLine [format "%-${FNlength}s" $file]
			OutLine "     (Missing)  "
		} else {
			if {[string length $file] <= $FNlength} {
				set str [format "%-${FNlength}s" $file]
				append str [format " %${FSlength}dk " [expr $filestat(size)/1024]]
			} else {
				set str $file
				set l [expr $FNlength+$FSlength - [string length $file]]
				if {$l<1} {set l 1}
				append str [format " %${l}dk " [expr $filestat(size)/1024]]
			}
			append str [clock format $filestat(mtime) -format %d-%m-%y]
			OutLine $str
			incr numfiles
			incr numbytes [expr $filestat(size)]
		}
		set comment [string range $line [string length $file] end]
		if {$makehtml} {
			puts $htmlout "<TR><TD><A HREF=\"$file\"><TT>$file</TT></A></TD>"
			puts $htmlout "<TD>$comment</TD></TR>"
		}
		set comment [split [string trim $comment]]
		for {set i 0} {$i<[llength $comment]} {incr i} {
			OutLine [lindex $comment $i]
		}
		puts $out ""; # terminating <nl>
		set numchars 0
	}
	close $infile
	puts $out [format "\n  Total:  %dK bytes in %d files\n" [expr $numbytes/1024] $numfiles]
	if {$makehtml} {
		puts $htmlout "</TABLE></BODY></HTML>"
		close $htmlout
	}
}

file copy -force $header $outputfile
set out [open $outputfile a]
fconfigure $out -buffering full -buffersize 32768
puts $out [format "Filelist created %s" [clock format [clock seconds]]]

set outreq [open $requestlist w]
if {$makehtml} {
	set outtoc [open $TOC w]
	puts $outtoc "<HTML><HEAD><TITLE>List of file areaf</TITLE></HEAD><BODY><P><CENTER>List of file areas</CENTER>"
}

foreach {dir} $path {
	set wwwpath [lindex $dir 2]
	set desc [lindex $dir 1]
	set dir [lindex $dir 0]
	if [file exists $dir] {
		puts stderr "Processing $dir $desc ..."
		ProcessDir $dir $desc
		if {$translateslashes} {
			regsub -all "/" $dir "\\" outstring
		} else {
			set outstring $dir
		}
		puts $outreq $outstring
		if {$makehtml && $wwwpath != ""} {
			puts $outtoc "<P><CENTER><A HREF=\"$wwwpath/$htmlname\">$desc</A></CENTER>"
		}
	} else {
		puts stderr "Directory $dir does not exists!"
	}
}
puts $out "\nThis filelist created with Filelist Tcl script"
close $out
if {$makehtml} {
	puts $outtoc "</BODY></HTML>"
	close $outtoc
}
