@echo off
setlocal enableextensions enabledelayedexpansion

if "%1" == "" goto HELP
if "%2" == "" goto HELP

set LOGSDIR=%1
set ARCDIR=%2
set NUMBER=%3
if "%NUMBER%" == "" set NUMBER=3

goto START

:HELP
	echo.
	echo Archives and deletes all log files in the LOGSDIR directory.
	echo Places an archive like yyyy.mm.dd.rar in the ARCDIR directory. Deletes
	echo files older than NUMBER months in it.
	echo 娢  㤠  䠩  ७ log  ४ਨ LOGSDIR.
	echo 頥 娢  yyyy.mm.dd.rar  ४ ARCDIR.    
	echo 䠩  NUMBER 楢.
	echo.
	echo Usage: %~nx0 LOGSDIR ARCDIR NUMBER
	echo ~~~~~~
	echo        LOGSDIR  - directory with log files.
	echo                   ४  log 䠩.
	echo        ARCDIR   - directory with archive files.
	echo                   ४  䠩 娢.
	echo        NUMBER   - how many months to keep archives. Default is 3.
	echo                   ᪮쪮 楢 ࠭ 娢.  㬮砭 3.
	echo.
	echo ਬ / For example
	echo %~nx0 d:\fido\logs d:\fido\logs\arc 5
	echo.
	goto END

:START
	set curday=%date:~0,-8%
	set curmonth=%date:~3,-5%
	set curyear=%date:~6%

	zip -mjq9D %ARCDIR%\%curyear%%curmonth%%curday% %LOGSDIR%\*.log

	set /a DELMONTH=%curmonth%-%NUMBER%

	if %DELMONTH% LEQ 0 (
		set /a DELMONTH=!DELMONTH! + 12
		set /a curyear=%curyear% - 1
	)
	set DELMONTH=0!DELMONTH!
	set DELMONTH=!DELMONTH:~-2!

	if exist %ARCDIR%\%curyear%.%DELMONTH%.%curday%.zip (
		del /f /q %ARCDIR%\%curyear%.%DELMONTH%.%curday%.zip
	)

:END
  exit
